using System;

class Program
{
    static void Main()
    {
        // Ucitavanje dimenzija matrice i dimenzija podmatrice
        string[] dimensions = Console.ReadLine().Split();
        int A = int.Parse(dimensions[0]);
        int B = int.Parse(dimensions[1]);
        int L = int.Parse(dimensions[2]);
        int K = int.Parse(dimensions[3]);

        // Ucitavanje elemenata niza AxB
        string[] elements = Console.ReadLine().Split();

        if (elements.Length != A * B)
        {
            Console.WriteLine("Neispravan unos niza elemenata.");
            return;
        }

        // Pretvaranje niza elemenata u matricu
        int[,] matrix = new int[A, B];

        for (int i = 0; i < A; i++)
        {
            for (int j = 0; j < B; j++)
            {
                matrix[i, j] = int.Parse(elements[i * B + j]);
            }
        }

        // Sortiranje niza elemenata u opadajucem redosledu
        Array.Sort(elements, (a, b) => int.Parse(b).CompareTo(int.Parse(a)));

        // Racunanje sume svih podmatrica dimenzija LxK
        long result = CalculateSumOfAllSubmatrices(matrix, A, B, K, L);

        // Ispis rezultata
        Console.WriteLine(result);
    }

    static long CalculateSumOfAllSubmatrices(int[,] matrix, int A, int B, int K, int L)
    {
        long totalSum = 0;

        // Iteriranje kroz sve podmatrice dimenzija LxK
        for (int i = 0; i <= A - L; i++)
        {
            for (int j = 0; j <= B - K; j++)
            {
                long submatrixSum = 0;

                // Racunanje sume podmatrice (L x K)
                for (int x = i; x < i + L; x++)
                {
                    for (int y = j; y < j + K; y++)
                    {
                        submatrixSum += matrix[x, y];
                    }
                }

                // Dodavanje sume podmatrice u ukupnu sumu
                totalSum += submatrixSum;
            }
        }

        return totalSum;
    }
}